﻿<?php
class MinecraftQueryException extends Exception
{
	
}

class MinecraftQuery
{
	
	 
	 
	 
	 
	 
	
	private $Socket;
	private $Challenge;
	private $Players;
	private $Info;
	
	public function Connect( $Ip, $Port = 25565, $Timeout = 3 )
	{
		if( $this->Socket = FSockOpen( 'udp://' . $Ip, (int)$Port ) )
		{
			Socket_Set_TimeOut( $this->Socket, $Timeout );
			
			if( !$this->GetChallenge( ) )
			{
				FClose( $this->Socket );
				throw new MinecraftQueryException( "Error." );
			}
			
			if( !$this->GetStatus( ) )
			{
				FClose( $this->Socket );
				throw new MinecraftQueryException( "Error." );
			}
			
			FClose( $this->Socket );
		}
		else
		{
			throw new MinecraftQueryException( "Error." );
		}
	}
	
	public function GetInfo( )
	{
		return isset( $this->Info ) ? $this->Info : false;
	}
	
	public function GetPlayers( )
	{
		return isset( $this->Players ) ? $this->Players : false;
	}
	
	private function GetChallenge( )
	{
		$Data = $this->WriteData( "\x09" );
	
		if( !$Data )
		{
			return false;
		}
		
		$this->Challenge = Pack( 'N', $Data );
		
		return true;
	}
	
	private function GetStatus( )
	{
		$Data = $this->WriteData( "\x00", $this->Challenge . "\x01\x02\x03\x04" );
		
		if( !$Data )
		{
			return false;
		}
		
		$Last = "";
		$Info = Array( );
		
		$Data    = SubStr( $Data, 11 ); // splitnum + 2 int
		$Data    = Explode( "\x00\x00\x01player_\x00\x00", $Data );
		$Players = SubStr( $Data[ 1 ], 0, -2 );
		$Data    = Explode( "\x00", $Data[ 0 ] );
		
		// Array with known keys in order to validate the result
		// It can happen that server sends custom strings containing bad things (who can know!)
		$Keys = Array(
			'hostname'   => '',
			'gametype'   => ' ',
			'version'    => '',
			'map'        => '',
			'numplayers' => '',
			'maxplayers' => '',
			'hostport'   => '',
			'hostip'     => 'IP'
		);
		
		if( $Data[ 18 ] == "hostname" ) { $Data[ 18 ] = "hostip"; } // Temporary fix
		
		foreach( $Data as $Key => $Value )
		{
			if( ~$Key & 1 )
			{
				if( !Array_Key_Exists( $Value, $Keys ) )
				{
					$Last = false;
					continue;
				}
				
				$Last = $Keys[ $Value ];
				$Info[ $Last ] = "";
			}
			else if( $Last != false )
			{
				
				
				$Info[ $Last ] = $Value;
			}
		}
		
		
	
		
		$this->Info = $Info;
		
		if( $Players )
		{
			$this->Players = Explode( "\x00", $Players );
		}
		
		return true;
	}
	
	private function WriteData( $Command, $Append = "" )
	{
		$Command = "\xFE\xFD" . $Command . "\x01\x02\x03\x04" . $Append;
		$Length  = StrLen( $Command );
		
		if( $Length !== FWrite( $this->Socket, $Command, $Length ) )
		{
			return false;
		}
		
		$Data = FRead( $this->Socket, 1440 );
		
		if( StrLen( $Data ) < 5 || $Data[ 0 ] != $Command[ 2 ] )
		{
			return false;
		}
		
		return SubStr( $Data, 5 );
	}
}
